
  import java.text.DecimalFormat;
  import javafx.application.Application;
  import javafx.event.*;
  import javafx.geometry.*;
  import javafx.scene.Scene;
  import javafx.scene.control.*;
  import javafx.scene.layout.*;
  import javafx.scene.text.Font;
  import javafx.stage.Stage;

  public class AddingMachineV2 extends Application 
  {
     Label description, plus, equals, sum, a, b;
     TextField aValue, bValue;
     Button compute, clear;

     @Override
     public void start(Stage primaryStage) 
     {
        //Step1: Declare the component objects, Step2: Set their properties
        description = new Label("Computes a + b");
        description.setFont(new Font("Arial", 24));
        aValue = new TextField();
        aValue.setPrefSize(120, 30);        plus = new Label("+");
        plus.setFont(new Font("Arial", 24));
        bValue = new TextField();
        bValue.setPrefSize(120, 30);        equals = new Label("=");
        equals.setFont(new Font("Arial", 24));
        sum = new Label("x,xxx.xx");
        sum.setFont(new Font("Arial", 16));
        sum.setMinWidth(68); 
        a = new Label("a");
        a.setFont(new Font("Arial", 24));
        b = new Label("b");
        b.setFont(new Font("Arial", 24));
        compute = new Button(" Compute ");
        compute.setOnAction( (e) -> computeClickHandler() );
        clear = new Button  ("  Clear   ");
        clear.setOnAction( (e) -> clearClickHandler() );
        Tooltip.install(clear, new Tooltip("Clears operands and result"));

        //Step 3: Declare the component container, and set its properties
        GridPane grid = new GridPane();
        grid.setHgap(10);
        grid.setVgap(10);
        grid.setPadding(new Insets(10, 0, 10, 10));
        grid.setHalignment(description, HPos.CENTER);
        grid.setHalignment(a, HPos.CENTER); 
        grid.setHalignment(b, HPos.CENTER);
        grid.setHalignment(compute, HPos.CENTER);
        grid.setHalignment(clear, HPos.CENTER);

        //Step 4: Add the components to the component container
        grid.add(description, 0, 0, 5, 1); 
        grid.add(aValue, 0, 1, 1, 1); 
        grid.add(plus, 1, 1, 1, 1);
        grid.add(bValue, 2, 1, 1, 1); 
        grid.add(equals, 3, 1, 1, 1);
        grid.add(sum, 4, 1, 1, 1);
        grid.add(a, 0, 2, 1, 1);
        grid.add(b, 2, 2, 1, 1);
        grid.add(compute, 0, 3, 1, 1); 
        grid.add(clear, 2, 3, 1, 1); 
        

        Scene scene = new Scene(grid); // add the container to the scene
        
        primaryStage.setTitle("Calculator");
        primaryStage.setScene(scene);
        primaryStage.show();
     }

     private void computeClickHandler()
     {
        String s;
        double a, b, result;
        DecimalFormat f = new DecimalFormat("#,##0.00");
        
        s = aValue.getText();
        a = Double.parseDouble(s);
        s = bValue.getText();
        b = Double.parseDouble(s);
        result = a + b;
        sum.setText(f.format(result));
     }

     private void clearClickHandler()
     {
        aValue.setText("");
        bValue.setText("");
        sum.setText("x,xxx.xx");
     }

     public static void main(String[] args) 
     {
        launch(args);
     }
  }


